<?php

use App\Http\Controllers\Admin\AbsensiController as AdminAbsensi;
use App\Http\Controllers\Admin\ActivityLogController;
use App\Http\Controllers\Admin\AdminCutiController;
use App\Http\Controllers\Admin\AdminShiftController;
use App\Http\Controllers\Admin\ApprovalController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboard;
use App\Http\Controllers\admin\DepartemenController;
use App\Http\Controllers\Admin\GajiController;
use App\Http\Controllers\Admin\JabatanController;
use App\Http\Controllers\Admin\JadwalShiftController;
use App\Http\Controllers\admin\JatahCutiController;
use App\Http\Controllers\Admin\KaryawanController;
use App\Http\Controllers\Admin\PengajuanController;
use App\Http\Controllers\Admin\WajahController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CutiController;
use App\Http\Controllers\Karyawan\AbsensiController;
use App\Http\Controllers\Karyawan\AjukanShiftController;
use App\Http\Controllers\Karyawan\DashboardController as KaryawanDashboard;
use App\Http\Controllers\Karyawan\GajiController as KaryawanGajiController;
// use App\Http\Controllers\Karyawan\DashboardController;
use App\Http\Controllers\Karyawan\PengajuanController as PengajuanKaryawan;
use App\Http\Controllers\Karyawan\SettingsController;
use App\Http\Controllers\NotifikasiController;
use App\Http\Controllers\UserController;
// use App\Models\AjukanShift;
use Illuminate\Support\Facades\Route;

// ========================
// ROOT REDIRECT
// ========================
Route::get('/', function () {
    if (auth()->check()) {
        $user = auth()->user();
        $hasAdminRole = in_array($user->role, ['admin', 'super_admin', 'manager', 'gm', 'hrd']);
        $hasKaryawanData = $user->karyawan && $user->karyawan->status === 'aktif';

        // Jika punya dual access dan belum pilih role, ke halaman pilihan
        if ($hasAdminRole && $hasKaryawanData && !session()->has('active_role')) {
            return redirect()->route('role.select');
        }

        // Redirect berdasarkan active_role atau role default
        $activeRole = session()->get('active_role');

        if ($activeRole === 'karyawan' || (!$activeRole && $hasKaryawanData && !$hasAdminRole)) {
            return redirect()->route('karyawan.dashboard');
        }

        if ($activeRole === 'admin' || (!$activeRole && $hasAdminRole)) {
            return redirect()->route('admin.dashboard');
        }

        return redirect()->route('karyawan.dashboard');
    }
    return redirect()->route('login');
});

Route::get('/welcome', function () {
    return view('welcome');
})->name('welcome');

// ========================
// GUEST ROUTES (Login & Register)
// ========================
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.post');
    Route::get('/captcha', [AuthController::class, 'generateCaptcha'])->name('captcha');

    Route::get('/register', [RegisterController::class, 'showRegister'])->name('register');
    Route::post('/register', [RegisterController::class, 'register'])->name('register.post');
    Route::get('/register/captcha', [RegisterController::class, 'generateCaptcha'])->name('register.captcha');
});

// ========================
// HOME REDIRECT (AUTHENTICATED)
// ========================
Route::get('/home', function () {
    if (!auth()->check()) {
        return redirect()->route('login');
    }

    $user = auth()->user();
    $hasAdminRole = in_array($user->role, ['admin', 'super_admin', 'manager', 'gm', 'hrd']);
    $hasKaryawanData = $user->karyawan && $user->karyawan->status === 'aktif';

    // Jika punya dual access dan belum pilih role, ke halaman pilihan
    if ($hasAdminRole && $hasKaryawanData && !session()->has('active_role')) {
        return redirect()->route('role.select');
    }

    $activeRole = session()->get('active_role');

    if ($activeRole === 'karyawan' || (!$activeRole && $hasKaryawanData && !$hasAdminRole)) {
        return redirect()->route('karyawan.dashboard');
    }

    if ($activeRole === 'admin' || (!$activeRole && $hasAdminRole)) {
        return redirect()->route('admin.dashboard');
    }

    return redirect()->route('login');
})->middleware('auth')->name('home');

// ========================
// AUTHENTICATION & ROLE SELECTION
// ========================
Route::middleware('auth')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    // Role Selection (untuk dual access users)
    Route::get('/role/select', [AuthController::class, 'showRoleSelection'])->name('role.select');
    Route::post('/role/set', [AuthController::class, 'setRole'])->name('role.set');
    Route::post('/role/switch', [AuthController::class, 'switchRole'])->name('role.switch');
});

// ========================
// ADMIN ROUTES (Super Admin, Admin, Manager, GM, HRD)
// Semua role admin menggunakan tampilan yang sama
// ========================
Route::middleware(['auth', 'role:super_admin|admin|manager|gm|hrd'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminDashboard::class, 'index'])->name('dashboard');

    // ========================
    // APPROVAL (Semua Role Admin, dibatasi di controller)
    // ========================
    Route::get('/approval', [ApprovalController::class, 'index'])->name('approval');
    Route::get('/approval/cuti/{id}', [ApprovalController::class, 'detail'])->name('approval-cuti.detail');

    // Cuti Approval Actions
    Route::post('/cuti/{id}/approve', [ApprovalController::class, 'approve'])->name('cuti.approve');
    Route::post('/cuti/{id}/reject', [ApprovalController::class, 'reject'])->name('cuti.reject');
    // Karyawan Approval (hanya super_admin)
    Route::post('/karyawan/{id}/approve', [ApprovalController::class, 'approveKaryawan'])->name('karyawan.approve');
    Route::post('/karyawan/{id}/reject', [ApprovalController::class, 'rejectKaryawan'])->name('karyawan.reject');

    // // Cuti Approval (super_admin, manager, gm, hrd - validasi di controller)
    // Route::post('/cuti/{id}/approve', [ApprovalController::class, 'approveCuti'])->name('cuti.approve');
    // Route::post('/cuti/{id}/reject', [ApprovalController::class, 'rejectCuti'])->name('cuti.reject');

    // Shift Approval (super_admin, admin)
    Route::post('/shift/{id}/approve', [ApprovalController::class, 'approveShift'])->name('shift.approve');
    Route::post('/shift/{id}/reject', [ApprovalController::class, 'rejectShift'])->name('shift.reject');

    // ========================
    // MANAGEMENT FEATURES (dibatasi di view/controller berdasarkan role)
    // ========================

    // Manajemen Jabatan (super_admin, admin)
    Route::resource('jabatan', JabatanController::class);

    // Manajemen Karyawan (super_admin, admin)
    Route::resource('karyawan', KaryawanController::class);

    // Laporan Absensi (super_admin, admin, manager, gm, hrd)
    Route::get('/absensi', [AdminAbsensi::class, 'index'])->name('absensi.index');
    Route::get('/absensi/export', [AdminAbsensi::class, 'export'])->name('absensi.export');

    // Gaji (super_admin, admin, hrd)
    Route::get('/gaji', [GajiController::class, 'index'])->name('gaji.index');
    Route::get('/gaji/create', [GajiController::class, 'create'])->name('gaji.create');
    Route::post('/gaji/hitung', [GajiController::class, 'hitung'])->name('gaji.hitung');
    Route::get('/gaji/{id}/slip', [GajiController::class, 'slip'])->name('gaji.slip');
    Route::get('/gaji/{id}/slip/pdf', [GajiController::class, 'slipPdf'])->name('gaji.slip.pdf');

    // User Management (super_admin)
    Route::get('/user', [UserController::class, 'index'])->name('user.index');
    Route::post('/user', [UserController::class, 'store'])->name('user.store');
    Route::put('/user/{user}', [UserController::class, 'update'])->name('user.update');
    Route::delete('/user/{user}', [UserController::class, 'destroy'])->name('user.destroy');

    // Cuti Management (super_admin, admin, hrd)
    Route::get('/cuti', [AdminCutiController::class, 'index'])->name('cuti');

    // Face Recognition (super_admin, admin, hrd)
    Route::get('/wajah', [WajahController::class, 'index'])->name('wajah.index');
    Route::get('/wajah/capture/{id}', [WajahController::class, 'capture'])->name('wajah.capture');
    Route::post('/wajah/store/{id}', [WajahController::class, 'store'])->name('wajah.store');

    // Jadwal Shift (super_admin, admin)
    Route::get('/jadwal', [JadwalShiftController::class, 'index'])->name('jadwal-shift.index');
    Route::post('/jadwal', [JadwalShiftController::class, 'store'])->name('jadwal-shift.store');
    Route::put('/jadwal/{jadwalShift}', [JadwalShiftController::class, 'update'])->name('jadwal-shift.update');
    Route::delete('/jadwal/{jadwalShift}', [JadwalShiftController::class, 'destroy'])->name('jadwal-shift.destroy');

    // Shift Management (super_admin, admin)
    Route::get('/shift', [AdminShiftController::class, 'index'])->name('shift.index');
    Route::post('/shift', [AdminShiftController::class, 'store'])->name('shift.store');
    Route::put('/shift/{shift}', [AdminShiftController::class, 'update'])->name('shift.update');
    Route::delete('/shift/{shift}', [AdminShiftController::class, 'destroy'])->name('shift.destroy');

    // Departemen manag (super_admin, admin)
    Route::get('/departemen', [DepartemenController::class, 'index'])->name('departemen.index');
    Route::post('/departemen', [DepartemenController::class, 'store'])->name('departemen.store');
    Route::put('/departemen/{id}', [DepartemenController::class, 'update'])->name('departemen.update');
    Route::delete('/departemen/{id}', [DepartemenController::class, 'destroy'])->name('departemen.destroy');

    // Jatah Cuti (super_admin, admin, hrd)
    Route::get('/jatah', [JatahCutiController::class, 'index'])->name('jatah-cuti.index');
    Route::post('/jatah', [JatahCutiController::class, 'store'])->name('jatah-cuti.store');
    Route::put('/jatah/{id}', [JatahCutiController::class, 'update'])->name('jatah-cuti.update');
    Route::delete('/jatah/{id}', [JatahCutiController::class, 'destroy'])->name('jatah-cuti.destroy');

    // Activity Log (super_admin, admin)
    Route::get('/activity-log', [ActivityLogController::class, 'index'])->name('activity-log.index');

    // Ajukan Shift Departemen (admin)
    Route::get('/shift/ajukan', [AjukanShift::class, 'index'])->name('ajukan-shift.index');
    Route::post('/shift/ajukan/store', [AjukanShift::class, 'store'])->name('ajulan-shift.store');
    Route::get('/shift/ajukan/cancel/{id}', [AjukanShift::class, 'cancel'])->name('ajulan-shift.cancel');
    Route::get('/shift/ajukan/show/{id}', [AjukanShift::class, 'show'])->name('ajulan-shift.show');
});

// ========================
// KARYAWAN ROUTES (Karyawan, Manager, GM, HRD)
// ========================
Route::middleware(['auth', 'role:karyawan|manager|gm|hrd'])->prefix('karyawan')->name('karyawan.')->group(function () {
    Route::get('/dashboard', [KaryawanDashboard::class, 'index'])->name('dashboard');

    // Pendaftaran Wajah (untuk karyawan yang belum daftar wajah)
Route::get('/wajah/register', [AbsensiController::class, 'registerFaceForm'])->name('wajah.register');
Route::post('/wajah/store', [AbsensiController::class, 'registerFaceStore'])->name('wajah.store');

    // Absensi
    Route::get('/absensi', [AbsensiController::class, 'index'])->name('absensi.index');
    Route::get('/absensi/masuk', [AbsensiController::class, 'masukForm'])->name('absensi.masuk.form');
    Route::post('/absensi/masuk', [AbsensiController::class, 'masuk'])->name('absensi.masuk');
    Route::get('/absensi/pulang', [AbsensiController::class, 'pulangForm'])->name('absensi.pulang.form');
    Route::post('/absensi/pulang', [AbsensiController::class, 'pulang'])->name('absensi.pulang');
    Route::post('/absensi/verify-face', [AbsensiController::class, 'verifyFace'])->name('absensi.verify');
    Route::get('/absensi/log', [AbsensiController::class, 'log'])->name('absensi.log');

    // Di routes/web.php
    Route::get('/pengajuan', [PengajuanKaryawan::class, 'index'])
        ->name('pengajuan.index');

    Route::get('/pengajuan/create', [PengajuanKaryawan::class, 'create'])
        ->name('pengajuan.create');

    Route::post('/pengajuan/cuti', [PengajuanKaryawan::class, 'storeCuti'])
        ->name('pengajuan.cuti');

    Route::get('/pengajuan/riwayat', [PengajuanKaryawan::class, 'riwayat'])
        ->name('pengajuan.riwayat');

    // Gaji
    Route::get('/gaji', [KaryawanGajiController::class, 'index'])->name('gaji.index');
    Route::get('/gaji/{id}/slip', [KaryawanGajiController::class, 'slip'])->name('gaji.slip');
    Route::get('/gaji/{id}/download', [KaryawanGajiController::class, 'download'])->name('gaji.download');

    // Settings
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/update-photo', [SettingsController::class, 'updatePhoto'])->name('settings.update-photo');
    Route::post('/settings/update-email', [SettingsController::class, 'updateEmail'])->name('settings.update-email');
    Route::post('/settings/update-password', [SettingsController::class, 'updatePassword'])->name('settings.update-password');

    Route::prefix('ajukan-shift')->name('ajukan-shift.')->group(function () {
    Route::get('/', [AjukanShiftController::class, 'index'])->name('index');
    Route::get('/create', [AjukanShiftController::class, 'create'])->name('create');
    Route::post('/store', [AjukanShiftController::class, 'store'])->name('store');
    Route::get('/riwayat', [AjukanShiftController::class, 'riwayat'])->name('riwayat');
    Route::get('/{id}', [AjukanShiftController::class, 'show'])->name('show');
    Route::post('/{id}/cancel', [AjukanShiftController::class, 'cancel'])->name('cancel');
});
});

// ========================
// NOTIFIKASI (AUTHENTICATED - ALL ROLES)
// ========================
Route::middleware(['auth'])->group(function() {

    // Display notifikasi
    Route::get('/notifikasi', [NotifikasiController::class, 'index'])
        ->name('notifikasi.index');

    // Mark as read
    Route::post('/notifikasi/{id}/read', [NotifikasiController::class, 'markAsRead'])
        ->name('notifikasi.read');

    Route::post('/notifikasi/mark-read-bulk', [NotifikasiController::class, 'markReadBulk'])
        ->name('notifikasi.mark-read-bulk');

    Route::post('/notifikasi/mark-all-read', [NotifikasiController::class, 'markAllAsRead'])
        ->name('notifikasi.mark-all-read');

    // Delete operations
    Route::post('/notifikasi/delete-bulk', [NotifikasiController::class, 'deleteBulk'])
        ->name('notifikasi.delete-bulk');

    Route::post('/notifikasi/delete-by-time', [NotifikasiController::class, 'deleteByTime'])
        ->name('notifikasi.delete-by-time');

    Route::post('/notifikasi/delete-read', [NotifikasiController::class, 'deleteRead'])
        ->name('notifikasi.delete-read');

    Route::post('/notifikasi/delete-all', [NotifikasiController::class, 'deleteAll'])
        ->name('notifikasi.delete-all');

    // Get unread count (untuk badge)
    Route::get('/notifikasi/unread-count', [NotifikasiController::class, 'getUnreadCount'])
        ->name('notifikasi.unread-count');
});
